<?php
/**
*
* @copyright	Inspiration Web Design
* License GNU/GPL
*/

// no direct access
defined('_JEXEC') or die('Restricted access');

if(file_exists(JPATH_SITE.'/components/com_k2/helpers/route.php'))
{
  require_once (JPATH_SITE.'/components/com_k2/helpers/route.php');
  require_once (JPATH_SITE.'/components/com_k2/helpers/utilities.php');
}


class modFeaturedItemsCarouselK2Helper
{
  /* helper class for Joomla Core Content */
	
	
	public static function getList(&$params)
	{
	  //returns object list
	  		global $mainframe;
			

		$db			= JFactory::getDBO();
		$user		= JFactory::getUser();
		$userId		= (int) $user->get('id');

		$count		= (int) $params->get('count', 10);
		if(is_array($params->get('k2catid')))
		{
		    $catid		= implode(',', $params->get('k2catid') );
		}
		else
		{
		    $catid = trim($params->get('k2catid'));	
		}
		if(is_array($params->get('k2articleid')))
		{
		    $articleid		= implode(',', $params->get('k2articleid') );
		}
		else
		{
		    $articleid	= trim( $params->get('k2articleid') );	
		}
		$show_featured	= $params->get('show_front', 1);
		$show_images= $params->get('show_images', 1);
		$align_images= $params->get('align_images', 'left');
		$use_gd      = $params->get('use_gd', 'no'); 
		$readmore    = $params->get('read_more','yes');
        $link_images = $params->get('link_images','yes');		  
		
		$count_chars      = $params->get('count_chars', 'yes');   
		$textcount	= (int) $params->get('textcount', 50);	
		$sentencecount	= (int) $params->get('sentencecount', 1);			
		$maxsize	= (int) $params->get('maximagesize', 100);		


		$nullDate	= $db->getNullDate();
		$dateFormat = $db->getDateFormat();

		$date = JFactory::getDate();
		$now = $date->format($date);
		
	    $jinput = JFactory::getApplication()->input;	  
		$option = $jinput->get('option');
		$view = $jinput->get('view');
		$task = $jinput->get('task','');		
		
		
        $profileId = (int) $jinput->get('userid','0','int');
		if($profileId == 0){ $profileId = (int) $jinput->get('user_id','0','int'); }
		if($profileId == 0){ $profileId = (int) $jinput->get('user','0','int'); }
		if(($profileId == 0) && ($option=='com_k2') && ($task=='user')){ $profileId = (int) $jinput->get('id','0','int'); }
		
		

		

        //get published filter
		$where		= 'a.published = 1'
			. ' AND ( a.publish_up = '.$db->Quote($nullDate).' OR a.publish_up <= '.$db->Quote($now).' )'
			. ' AND ( a.publish_down = '.$db->Quote($nullDate).' OR a.publish_down >= '.$db->Quote($now).' )'
			;
		

		// User Filter
		switch ($params->get( 'user_id' ))
		{
			case 'by_me':
				$where .= ' AND (created_by = ' . (int) $userId . ' OR modified_by = ' . (int) $userId . ')';
				break;
			case 'not_me':
				$where .= ' AND (created_by <> ' . (int) $userId . ' AND modified_by <> ' . (int) $userId . ')';
				break;
		}
		
				
		
		if(($params->get( 'user_id' ) == 'profile') && ($option == "com_community") && ($view == 'profile'))
		{
			$where .= ' AND (created_by = ' . (int) $profileId . ' OR modified_by = ' . (int) $profileId . ')';
		}
		else if(($params->get( 'user_id' ) == 'profile') && ($option == "com_comprofiler") && ($task == 'userProfile'))
		{
			//community builder
			$where .= ' AND (created_by = ' . (int) $profileId . ' OR modified_by = ' . (int) $profileId . ')';
			
		}
		else if(($params->get( 'user_id' ) == 'profile') && ($option == "com_k2") && ($task == 'user'))
		{
			//k2
			$where .= ' AND (created_by = ' . (int) $profileId . ' OR modified_by = ' . (int) $profileId . ')';
			
		}
		
		//access filter
		$accessCondition = '';
		$groups	= implode(',', $user->getAuthorisedViewLevels());
		$accessCondition = ' AND (cc.access IN ('.$groups.')) ';
		$accessCondition .= ' AND (a.access IN ('.$groups.')) ';
		
		

		
        //get filters for all sections, categories, authors list 
        $featuredCondition = '';
		if($show_featured == '2')
		{
			$featuredCondition = ' AND featured=1 ';
		}
		else if($show_featured == '0')
		{
			$featuredCondition = ' AND featured=0 ';
		}
		
		
		$catCondition = '';
		$artCondition = '';
        //get filters for all list types
		if ($catid)
		{
			$ids = explode( ',', $catid );
			JArrayHelper::toInteger( $ids );
			$catCondition = ' AND (cc.id=' . implode( ' OR cc.id=', $ids ) . ')';
		}
		if ($articleid)
		{
			$ids = explode( ',', $articleid );
			JArrayHelper::toInteger( $ids );
			$artCondition = ' AND (a.id=' . implode( ' OR a.id=', $ids ) . ')';
		}
		
		
	   if( $params->get('use_request','no') == 'yes')
	   {
		   //use request value instead if this is set and the user request parameter is true
		    $option = $jinput->get('option');
			$view = $jinput->get('view');

	      	if (($view == 'itemlist') && ($option == 'com_k2')) {
		        $app = &JApplication::getInstance('site');
		        $k2params = $app->getPageParameters('com_k2');
				$categories = $k2params->get('categories');
				
				if(is_array($categories))
				{
			        JArrayHelper::toInteger( $categories );					
			        $catCondition = ' AND (cc.id=' . implode( ' OR cc.id=', $categories ) . ')';
				}
				else
				{
					$categories = intval(trim($categories));	
					if($categories > 0)
					{
			           $catCondition = ' AND (cc.id='.strval($categories).') ';
					}
					
				}
				
			  
			}
	      	else if (($view == 'item') && ($option == 'com_k2')) {
			  $id = intval($jinput->get('id',0,'int'));
			  if($id > 0)
			  {
				 $query = $db->getQuery(true);
				 $query->select("catid");
				 $query->from("#__k2_items");
				 $query->where("id=".$id);
				 $db->setQuery($query, 0, 1);
		         if($category = $db->loadResult())
				 {
			         $catCondition = ' AND (cc.id='.strval($category).') ';
				 }
			  }
				
			}
	      	else if (($view == 'latest') && ($option == 'com_k2')) {
		        $app = &JApplication::getInstance('site');
		        $k2params = $app->getPageParameters('com_k2');
				$source = $k2params->get('source');
				
				if($source == '1')
				{
					$categories = $k2params->get('categoryIDs');
					if(is_array($categories))
					{
						JArrayHelper::toInteger( $categories );					
						$catCondition = ' AND (cc.id=' . implode( ' OR cc.id=', $categories ) . ')';
					}
					else
					{
						$categories = intval(trim($categories));	
						if($categories > 0)
						{
						   $catCondition = ' AND (cc.id='.strval($categories).') ';
						}
						
					}
				}
				else 
				{
					//users list
					$users = $k2params->get('userIDs');
					if(is_array($users))
					{
						JArrayHelper::toInteger( $users );					
						$catCondition = ' AND (a.created_by=' . implode( ' OR a.created_by=', $users ) . ' OR a.modified_by='.implode( ' OR a.modified_by=', $users ).') ';
					}
					else
					{
						$users = intval(trim($users));	
						if($users > 0)
						{
						   $catCondition = ' AND (a.created_by='.strval($users).' OR a.modified_by='.strval($users).') ';
						}
						
					}
					
				}
			} //end if view == latest
	   }	//end if use request					
		
		// Ordering
		switch ($params->get( 'ordering' ))
		{
		    case 'title': $ordering = 'a.title ASC';
			              break;				
		    case 'h_dsc': $ordering = 'a.hits DESC';
			              break; 
			case 'h_asc': $ordering = 'a.hits ASC';
			              break;
            case 'o_asc': $ordering = 'a.ordering ASC';
			              break;						  
			case 'm_dsc': $ordering = 'a.modified DESC, a.created DESC';
				          break;
			case 'random': $ordering = 'RAND()';
			          break;						  
			case 'c_dsc':
			case 'list':									
			default:  $ordering = 'a.created DESC';
				      break;
		}		
		

		$where = $where.$accessCondition.$catCondition.$artCondition.$featuredCondition.' AND cc.published = 1';
		$query = $db->getQuery(true);

		// Content Items only
		$query->select('a.*,  u.name AS name, cc.alias AS categoryalias');
		$query->from('#__k2_items AS a');
		$query->innerJoin('#__k2_categories AS cc ON cc.id = a.catid');
		$query->leftJoin('#__users AS u ON u.id = a.created_by');
		$query->where($where);
		$query->order($ordering);
			
			//echo $query;
			
		$db->setQuery($query, 0, $count);
		$rows = $db->loadObjectList();
			
			if(count($rows) == 0){ return $rows; }

		
		
		if((!empty($articleid)) && ($params->get('ordering')=='list'))
		{
		   $ids = explode( ',', $articleid );
		   JArrayHelper::toInteger( $ids );
		   
		   $listRows = array();
		   
		   foreach ($ids as $id)
		   {
		     foreach ($rows as $row)
		     {
               if( $row->id == $id)
			   {
			     $listRows[] = $row;
			   }
		     }
		   }
		   $rows = $listRows;				
		}		
		
	    return $rows;
	}
	
	public static function getImageTag(&$params, &$row, $title = '')
	{
		
		$show_images= $params->get('show_images', '1');
		$align_images= $params->get('align_images', 'left');
		$use_gd      = $params->get('use_gd', 'no'); 
		$maxsize	= (int) $params->get('maximagesize', 100);	
		$maximagetype = $params->get('maximagetype','both');
		$imagefieldsize = $params->get('k2_image_size','_XS');
		
	    $filterTags = array();
	    $filterAttrs = array();
		$filter	= new JFilterInput( $filterTags, $filterAttrs, 0, 0 );
		
		$size = FALSE;
		$imageURL = '';
		$imageTag = '';
		if($show_images == '0')
		{
		  return $imageTag;	
		}
		
		
		if (preg_match('/<!--image:(.*?)-->/',$row->introtext, $matches))
		{
		  $imageURL = $filter->clean( $matches[1], 'PATH' );
		  
		  $altText = '';
		  if (preg_match('/<!--alt:(.*?)-->/',$row->introtext, $matches))
		  $altText = $filter->clean( $matches[1] );
		  
			 
		}	//end if preg_match	
			
		else if (JFile::exists(JPATH_SITE.'/media/k2/items/cache/'.md5("Image".$row->id).$imagefieldsize.'.jpg'))
		{
		   $imageURL = JURI::root().'media/k2/items/cache/'.md5("Image".$row->id).$imagefieldsize.'.jpg';
		   $imageTag = '<img  src="' . $imageURL . '" alt="' . $title . '" title="' . $title . '" style="float:' . $align_images .'" class="featureditemscarousel_image"/>';
		   return $imageTag;
		}
		
		
			
			
		  else if (  preg_match('/<img[^>]*>/i', $row->introtext, $matches ) == 1)
		  {
			 $imageTag = $matches[0];
			 $altText = '';
			 $titleText = '';

			if (preg_match('/alt=[\'"]([^\'"]*)[\'"]/i', $imageTag, $altmatches ) == 1)
			{
			   $altText = $altmatches[1];
			} 
			
			if (preg_match('/title=[\'"]([^\'"]*)[\'"]/i', $imageTag, $titlematches ) == 1)
			{
			   $titleText = $titlematches[1];
			} 			  
			 
			if (preg_match('/src=[\'"]([^\'"]*)[\'"]/i', $imageTag, $morematches ) == 1)
			{
			   $imageURL = $morematches[1];
			   
			 }
		   }

			if( $imageURL != '')
			{

			   $liveSite 	= JURI::base();
			   $imageURL = str_replace( $liveSite, '', $imageURL );
			   
			   
			   $imagePath = str_replace( JPATH_BASE, '', $imageURL);
			   $imagePath = str_replace('\\','/',$imagePath);
			   
			  //$imagePath = JPATH_BASE.DS.$imagePath;
				   
				   
			   $size = @getimagesize(rawurldecode($imagePath));
			}
			else
			{
			 return $imageTag;	
			}

			 if ( $size )
			 {
				$width = $size[0];
				$height = $size[1];

				  if($maximagetype == 'both'){
					  
					  if (($width > $height) && ($width > $maxsize ))
					  {
						$ratio = $maxsize/$width;
						$newwidth = $maxsize;
						$newheight = intval($height * $ratio);
					  }
					  else if (($width <= $height) && ($height > $maxsize))
					  {
						$ratio = $maxsize/$height;
						$newheight = $maxsize;
						$newwidth = intval($width * $ratio);
					  }
					  else
					  {
						$newwidth = $width;
						$newheight = $height;
					  }
				  }
				  else 	if($maximagetype == 'width'){
					  if ($width > $maxsize )
					  {
						$ratio = $maxsize/$width;
						$newwidth = $maxsize;
						$newheight = intval($height * $ratio);
					  }
					  else
					  {
						$newwidth = $width;
						$newheight = $height;
					  }					  					  
				  }
				  else { //use height
				  
					 if ($height > $maxsize)
					 {					  
						$ratio = $maxsize/$height;
						$newheight = $maxsize;
						$newwidth = intval($width * $ratio);
					 }
					  else
					  {
						$newwidth = $width;
						$newheight = $height;
					  }					  					  						 					  
				  }
				  
				  if ( $use_gd == 'yes' ){
					 $imageURL = 'modules/mod_featureditems_carousel/assets/resize.php?img=' . rawurlencode($imageURL ) . '&amp;width=' . $newwidth . '&amp;height=' .$newheight;
				  
				  }
			      $imageTag = '<img  src="' . $imageURL . '" width="' . $newwidth. 'px" height="' . $newheight . 'px" alt="' . $altText . '" title="' . $title . '" style="float:' . $align_images .'" class="featureditemscarousel_image"/>';
				  
				  
			 
			 }//end if ( $size )
			 else  
			 {
				 //can't resize image file, usually because the image file path is incorrect, so let browser do this
				 
				 if(($maximagetype == 'width') || ($maximagetype == 'both'))
				 {
			          $imageTag = '<img  src="' . $imageURL . '" width="' . $maxsize. 'px" alt="' . $altText . '" title="' . $title . '" style="float:' . $align_images .'" class="featureditemscarousel_image"/>';
					 
					 
				 }
				 else
				 {
			          $imageTag = '<img  src="' . $imageURL . '" height="' . $maxsize. 'px" alt="' . $altText . '" title="' . $title . '" style="float:' . $align_images .'" class="featureditemscarousel_image"/>';
				 }
				 
			 }
		     
			 return $imageTag;
		
	}//end get image tag
	
	public static function getLink(&$params, &$row)
	{
	   //$link = ContentHelperRoute::getArticleRoute($row->slug, $row->catslug, $row->sectionid);
		$link = K2HelperRoute::getItemRoute($row->id.':'.urlencode($row->alias), $row->catid.':'.urlencode($row->categoryalias));
	   
	   return $link;
	
	}
	



}