<?php
/**
*
* @copyright	Inspiration Web Design
* License GNU/GPL
*/

// no direct access
defined('_JEXEC') or die('Restricted access');


abstract class JHtmlScrollpane
{
    protected static $scrollClass = '';
	protected static $scrollDirection = ' horizontal';
	protected static $scripts = '';
	protected static $imageSliders = false;
	protected static $imageTransition = 'horizontal-slide';
	protected static $options = null;
	 
	 
	function __construct( $params = array() )
	{

	}
	
	public static function setOptions($params = array())
	{
		self::$scrollClass  = (isset($params['scrollEvent'])) ? ' '.$params['scrollEvent'] : '' ;				
	    self::$scrollDirection = (isset($params['scrollDirection'])) ? ' '.$params['scrollDirection'] : ' horizontal' ;
	    self::$imageSliders = (isset($params['imageSliders'])) ? $params['imageSliders'] : false;
	    self::$imageTransition = (isset($params['imageTransition'])) ? $params['imageTransition'] : 'horizontal-slide';
		
		$options = '{';
		$opt = array();
		
		$opt['showButtons']		= (isset($params['showButtons'])) ? '\''.$params['showButtons'].'\'' : '\'yes\'' ;
		$opt['autoScroll']		= (isset($params['autoScroll'])) ? '\''.$params['autoScroll'].'\'' : '\'no\'' ;
		$opt['milliseconds']		= (isset($params['milliseconds'])) ? $params['milliseconds'] : 10000 ;
		
		foreach ($opt as $k => $v)
		{
			if ($v) {
				$options .= $k.': '.$v.',';
			}
		}						
		if (substr($options, -1) == ',') {
			$options = substr($options, 0, -1);
		}
		
		
		$options .= '}';

        self::$options = $options;		
		
		
	}
	
		/**
	 * Creates a pane and creates the javascript object for it
	 *
	 * @param string The pane identifier
	 */
	public static function start( $id, $params = array() )
	{
		static $loaded = false;		
		self::setOptions($params);
		
		//$config = JFactory::getConfig();
		//$caching = $config->getValue('config.caching');
		$caching = false;
		$document = JFactory::getDocument();
		
        $imageSlide = '';
		if(self::$imageSliders)
		{
			$imageSlide = '$$(\'div#'.$id.' div.scrollpanel\').each(function(isd){ var imageSlide = new ImageSlider(isd,{\'transition\':\''.self::$imageTransition.'\'});});';
			
		}		
		
	    $js = 'window.addEvent(\'domready\', function(){ $$(\'div#'.$id.'_outer\').each(function(scrollers){ var scroller = new JScrollers(scrollers, '.self::$options.'); }); '.$imageSlide.' });';

		
        if(!$caching)
		{
		   $document->addScriptDeclaration( $js );  
		}
		else
		{
		    echo '<script type="text/javascript">'.$js.'</script>';	
		}
		
		if (!$loaded) {
			self::_loadBehavior($params);
			$loaded = true;
		}
		
		
		
		return '<div class="carousel_outer' . self::$scrollClass. self::$scrollDirection .'" id="'.$id.'_outer"><div class="carousel_inner" id="'.$id.'_inner">';
	}

	/**
	 * Ends the pane
	 */
	public static function end()
	{
		return "</div></div>";
	}

	/**
	 * Creates a scroll panel with title text and starts that panel
	 *
	 * @param	string	$text	The name of the tab
	 * @param	string	$id		The tab identifier
	 */
	public static function panel( $text, $id )
	{
		return '<div id="'.$id.'" class="scrollpanel">'.$text;
	}

	/**
	 * Ends a tab page
	 */
	function endPanel()
	{
		return "</div>";
	}

	
	protected static function _loadBehavior($params = array())
	{
		// Include mootools framework
		JHTML::_('behavior.framework');
		//is caching enabled?
		//$config = JFactory::getConfig();
		//$caching = $config->getValue('config.caching');
		$caching = false;
		
		
		
	
		$document = JFactory::getDocument();
		if(!$caching)
		{
 	        $document->addScript( JURI::root(true).    '/modules/mod_featureditems_carousel/js/scrollpane.js' );
			if(self::$imageSliders)
			{
 	             $document->addScript( JURI::root(true).    '/modules/mod_featureditems_carousel/js/imageslider.js' );
			}
		}
		else
		{
		    self::$scripts = '<script type="text/javascript" src="'. JURI::root(true).    '/modules/mod_featureditems_carousel/js/scrollpane.js"></script>';
			if(self::$imageSliders)
			{
		         self::$scripts = self::$scripts . '<script type="text/javascript" src="'. JURI::root(true).    '/modules/mod_featureditems_carousel/js/imageslider.js"></script>';				
			}
		}
		

		if($caching)
		{
		   echo self::$scripts;
		}
    }
	
	
	
}

