<?php
/*
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );


jimport('joomla.html.html');
jimport('joomla.form.formfield');


/**
 * Supports an HTML select list of articles
 * @since		1.6
 */
class JFormFieldArticles extends JFormField
{
	/**
	 * The form field type.
	 *
	 * @var		string
	 * @since	1.6
	 */
	protected $type = 'Articles';

	/**
	 * Method to get content articles
	 *
	 * @return	array	The field option objects.
	 * @since	1.6
	 */
	protected function getInput()
	{
		// Initialize variables.
		$session = JFactory::getSession();
		$options = array();
		
		$attr = '';

		// Initialize some field attributes.
		$attr .= $this->element['class'] ? ' class="'.(string) $this->element['class'].'"' : '';

		// To avoid user's confusion, readonly="true" should imply disabled="true".
		if ( (string) $this->element['readonly'] == 'true' || (string) $this->element['disabled'] == 'true') {
			$attr .= ' disabled="disabled"';
		}

		$attr .= $this->element['size'] ? ' size="'.(int) $this->element['size'].'"' : '';
		$attr .= $this->multiple ? ' multiple="multiple"' : '';

		// Initialize JavaScript field attributes.
		$attr .= $this->element['onchange'] ? ' onchange="'.(string) $this->element['onchange'].'"' : '';
		

			
		$db = JFactory::getDBO();
		$query = $db->getQuery(true);
		$query->select('*');
		$query->from('#__categories');
		$query->where('published=1');
		$query->order('parent_id');
		$db->setQuery( $query );
		$categories = $db->loadObjectList();
		
		$articles=array();
		
		// set up first element of the array as all articles
		$optgroup = JHTML::_('select.optgroup',JText::_("All articles"),'id','title');
	    array_push($articles,$optgroup);
		
		$articles[1] = new stdClass();
		$articles[1]->id = '';
		$articles[1]->title = JText::_("All articles");
		
		  //loop through categories 
		  foreach ($categories as $category) {
			  $query = $db->getQuery(true);
			  $query->select('id,title');
			  $query->from('#__content');
			  $query->where('catid='.$category->id);
			  $db->setQuery( $query );
			  $results = $db->loadObjectList();
			  if(count($results)>0)
			  {
				if(!empty($category->title))
				{
				  $optgroup = JHTML::_('select.optgroup',$category->title,'id','title');
				  array_push($articles,$optgroup);
				}
				  
				foreach ($results as $result) {
					array_push($articles,$result);
				}
			  }
		  }			
			
		// Output
		
		return JHTML::_('select.genericlist',  $articles, $this->name, trim($attr), 'id', 'title', $this->value );
		
	}
}


