<?php
/*
*/

// no direct access
defined( '_JEXEC' ) or die( 'Restricted access' );
jimport('joomla.html.html');
jimport('joomla.form.formfield');
jimport('joomla.form.helper');
JFormHelper::loadFieldClass('list');


// Category element
class JFormFieldK2Articles extends JFormFieldList{

	public $type = 'k2articles';
	
	protected function getInput()
	{
		
		$attr = '';

		// Initialize some field attributes.
		$attr .= $this->element['class'] ? ' class="'.(string) $this->element['class'].'"' : '';

		// To avoid user's confusion, readonly="true" should imply disabled="true".
		if ( (string) $this->element['readonly'] == 'true' || (string) $this->element['disabled'] == 'true') {
			$attr .= ' disabled="disabled"';
		}

		$attr .= $this->element['size'] ? ' size="'.(int) $this->element['size'].'"' : '';
		$attr .= $this->multiple ? ' multiple="multiple"' : '';

		// Initialize JavaScript field attributes.
		$attr .= $this->element['onchange'] ? ' onchange="'.(string) $this->element['onchange'].'"' : '';
		
		
		$db = &JFactory::getDBO();
		
		$tables = $db->getTableList();
		$k2installed = false;
		foreach($tables as $table)
		{
			$pos = stripos($table,'k2_categories');
			if($pos !== false)
			{
				$k2installed = true;
			}
		}
		if(!$k2installed){return '';}
		
		$query = $db->getQuery(true);
		$query->select('id as value, name as text');
		$query->from('#__k2_categories');
		$query->where('published=1 AND trash=0');
        $query->order('parent, ordering');		
		
		$db->setQuery( $query );
		if(!$categories = $db->loadObjectList())
		{
			return JTEXT::_('K2NOARTICLES');
		}
		
		if(count($categories) == 0)
		{
			return JTEXT::_('K2NOARTICLES');
		 
	    }

		
		$articles=array();
		
		// set up first element of the array as all articles
		$articles[0]->value = '';
		$articles[0]->text = JText::_("ALLARTICLES");
		
		//loop through categories 
		foreach ($categories as $category) {
			$optgroup = JHTML::_('select.optgroup',$category->text,'value','text');
		    $query = $db->getQuery(true);
			$query->select('id as value,title as text');
			$query->from('#__k2_items');
			$query->where('catid='.$category->value .' AND trash=0 AND published=1');
			
			$db->setQuery( $query );
			$results = $db->loadObjectList();
			array_push($articles,$optgroup);
			foreach ($results as $result) {
				array_push($articles,$result);
			}
		}
				
		//return $articles;
		return JHTML::_('select.genericlist',  $articles, $this->name, trim($attr), 'value', 'text', $this->value );
		
	}
	
} 
