// JavaScript Document

var ImageSlider = new Class({
    getOptions: function(){
        return {
			transition:'horizontal-slide'			
        };
    },
    initialize: function(dlist, options){
        this.setOptions(this.getOptions(), options);
		var ms = new String(MooTools.version);
		this.version = ms.substr(0,3);
		if(this.version == '1.1')
		{	
            this.dlist = $(dlist);
		}
		else
		{
            this.dlist = document.id(dlist);
		}
		this.im = this.dlist.getElement('img');
		this.slider = null;
		this.text = this.dlist.getElement('div');
		this.children = this.getDescendents(this.dlist);
		this.parent = this.dlist.getParent();
		
		var ms = new String(MooTools.version);
		this.version = ms.substr(0,3);
		
		if(this.version == '1.1')
		{		
			  switch(this.options.transition)
			  {
				  case "horizontal-slide": this.slider = new Fx.Slide(this.im, {mode: 'horizontal', duration: 250});
				                this.im.addEvent('mouseover', function(e){this.slider.slideOut();}.bind(this));
				                this.dlist.addEvent('mouseout', function(e){ e = new Event(e); e.stop(); if(!this.children.contains(e.relatedTarget)){this.slider.slideIn();}}.bind(this));
								
					   break;
				  case "vertical-slide": this.slider = new Fx.Slide(this.im, {mode: 'vertical', duration: 250});
				                this.im.addEvent('mouseover', function(e){this.slider.slideOut();}.bind(this));
				                this.dlist.addEvent('mouseout', function(e){ e = new Event(e); e.stop(); if(!this.children.contains(e.relatedTarget)){this.slider.slideIn();}}.bind(this));
								
					   break;
					   
				  case "fade": this.fader = new Fx.Style(this.im,'opacity', {duration:500});
			                   this.im.addEvent('mouseover', function(e){this.fader.start(1,0);}.bind(this));
				               this.dlist.addEvent('mouseout', function(e){e = new Event(e); e.stop(); if(!this.children.contains(e.relatedTarget)){this.fader.start(0,1);}}.bind(this));
					  
							 break;
				  case "none": break;
				  
			  }
		}
		else
		{
			switch(this.options.transition)
			{
				case "horizontal-slide":  this.slider = new Fx.Slide(this.im, {mode: 'horizontal', duration: 250});
				              this.im.addEvent('mouseover', function(e){e.stop(); this.slider.slideOut();}.bind(this));
				              this.dlist.addEvent('mouseout', function(e){e.stop(); if(!this.children.contains(e.relatedTarget)){this.slider.slideIn();}}.bind(this));
				
				     break;
				case "vertical-slide":  this.slider = new Fx.Slide(this.im, {mode: 'vertical', duration: 250});
				              this.im.addEvent('mouseover', function(e){e.stop(); this.slider.slideOut();}.bind(this));
				              this.dlist.addEvent('mouseout', function(e){e.stop(); if(!this.children.contains(e.relatedTarget)){this.slider.slideIn();}}.bind(this));
				
				     break;
					 
			    case "fade": this.fader = new Fx.Tween(this.im,'opacity', {duration:500});
			                 this.im.addEvent('mouseover', function(e){this.im.fade('out');}.bind(this));
				             this.dlist.addEvent('mouseout', function(e){e.stop(); if(!this.children.contains(e.relatedTarget)){this.im.fade('in');}}.bind(this));
				
				           break;
				case "none": break;
				
			}
			
			
		}
		
	},
	getDescendents: function(el)
	{
		
		var descendents = new Array(el);
		var children = el.getChildren();
		if(children.length > 0)
		{
			for(var i=0; i<children.length; i++)
			{	
				descendents.combine(this.getDescendents(children[i]));
			}
			
		}
		
		return descendents;
	}
							
});

ImageSlider.implement(new Events);
ImageSlider.implement(new Options);
