<?php
set_include_path(get_include_path().PATH_SEPARATOR.
                 dirname(__FILE__)."/src/");
require_once("src/jpgraph.php");
require_once("src/jpgraph_bar.php");

$donnees = unserialize($_GET["data"]);
$title = $_GET["title"];
$legend = unserialize(urldecode($_GET["legend"]));
$unit = $_GET["unit"];
$largeur = 1000;
$hauteur = 900;

// Initialisation du graphique
$graphe = new Graph($largeur, $hauteur);
$graphe->setScale("textlin");
// Creation du camembert
$histo = new BarPlot($donnees);
// Ajout du camembert au graphique
$graphe->add($histo);
$histo->SetFillColor(array('blue','green','green', 'green', 'green', 'green', 'green', 'green', 'green', 'green', 'green', 'green', 'turquoise'));
$histo->value->Show();
$histo->value->SetFont(FF_ARIAL,FS_NORMAL,9);


// Ajout du titre du graphique
if ($title == "Taux d'utilisation par stations")
{
$graphe->yscale->SetAutoMax(100);
}
$graphe->title->set($title);
$graphe->xaxis->SetTickLabels($legend);
// Affichage du graphique
// @unlink("graph/histo.png");
// $graphe->stroke("graph/histo.png");
$graphe->stroke();
?>
