<?php
try
{
$db = new PDO('mysql:host=localhost;dbname=csv_db', 'root', '7h2ZfUB7');
}
catch (Exception $e)
{
        die('Erreur : ' . $e->getMessage());
}

$req = array(
	"general" => 'SELECT * FROM test WHERE `Trip Billing End` LIKE :date',
	"station" => 'SELECT * FROM test WHERE `Trip Billing End` LIKE :date AND `Billed lot` = :station',
	"hebdo" => 'SELECT * FROM test WHERE `Billed lot` = :station AND DATE_FORMAT(:date, "%d/%m/%y") BETWEEN DATE_FORMAT(`Trip Billing Start`, "%d/%m/%y") AND DATE_FORMAT(`Trip Billing End`, "%d/%m/%y"))',
	"hebdo_car" => 'SELECT * FROM test WHERE `Billed lot` = :station AND `Driven Vehicle Plate` = :car AND (DATE_FORMAT(DATE_SUB(DATE_FORMAT(:date, "%d/%m/%y"), INTERVAL :nbd DAY), "%y/%m/%d") BETWEEN DATE_FORMAT(`Trip Billing Start`, "%d/%m/%y") AND DATE_FORMAT(`Trip Billing End`, "%d/%m/%y"))',
	"car" => 'SELECT * FROM test WHERE `Trip Billing End` LIKE :date AND `Billed lot` = :station AND `Driven Vehicle Plate` = :car',
	"tcar" => 'SELECT * FROM test WHERE `Trip Billing End` LIKE :date AND `Billed lot` = :station AND `Driven Vehicle Type` = :tcar',
	"tuser" => 'SELECT * FROM test WHERE `Trip Billing End` LIKE :date AND `Billed Rate Plan` = :tuser',
	"Ugeneral" => 'SELECT `Billed Rate Plan` FROM test WHERE `Trip Billing End` LIKE :date ORDER BY `Billed Rate Plan`',
	"Ustation" => 'SELECT `Billed Rate Plan` FROM test WHERE `Trip Billing End` LIKE :date AND `Billed Lot` = :station ORDER BY `Billed Rate Plan`',
	"Ucar" => 'SELECT `Billed Rate Plan` FROM test WHERE `Trip Billing End` LIKE :date AND `Billed Lot` = :station AND `Driven Vehicle Plate` = :car ORDER BY `Billed Rate Plan`',
	"Utcar" => 'SELECT `Billed Rate Plan` FROM test WHERE `Trip Billing End` LIKE :date AND `Billed Lot` = :station AND `Driven Vehicle Type` = :tcar ORDER BY `Billed Rate Plan`',
	"list_tcar" => 'SELECT DISTINCT `Driven Vehicle Type` FROM test ORDER BY `Driven Vehicle Type`',
	"list_tuser" => 'SELECT DISTINCT `e Type` FROM test ORDER BY `Driven Vehicle Type`',
	"list_station" => 'SELECT DISTINCT `Billed Lot` FROM test WHERE `Trip Billing End` LIKE :date`',
		);

function Get_data($type, $year, $month, $data=null)
{
$req = $GLOBALS["req"];
global $db;
$query=$db->prepare($req[$type]);
if ($type == "general" or $type == "Ugeneral")
{
$query->execute(array(
		'date' => '__/'.$month.'/'.$year.'%',
		));
}

else if ($type == "hebdo")
{
$query->execute(array(
		'date' => date('m/d/y H:i', strtotime($data["day"].'/'.$month.'/'.$year.' 12:00:00 AM')),
		'station' => $data["station"],
		));
}
else if ($type == "hebdo_car")
{
$query->execute(array(
		'date' => date('m/d/y H:i', strtotime($data["day"].'/'.$month.'/'.$year.' 12:00:00 AM')),
		'station' => $data["station"],
		'nbd' => $data["nbd"],
		'car' => $data["car"],
		));
}
else if ($type == "station" or $type == "Ustation")
{
$query->execute(array(
		'date' => '__/'.$month.'/'.$year.'%',
		'station' => $data["station"],
		));
}
else if ($type == "car" or $type == "Ucar")
{
$query->execute(array(
		'date' => '__/'.$month.'/'.$year.'%',
		'station' => $data["station"],
		'car' => $data["car"],
		));
}
else if ($type == "tcar" or $type == "Utcar")
{
$query->execute(array(
		'date' => '__/'.$month.'/'.$year.'%',
		'station' => $data["station"],
		'tcar' => $data["tcar"],
		));
}
else if ($type == "tuser" or $type == "Utuser")
{
$query->execute(array(
		'date' => '__/'.$month.'/'.$year.'%',
		'tuser' => $data["tuser"],
		));

}
return $query->fetchAll();
}

function Station_data($station)
{
$month=$_GLOBALS["month"];
$year=$_GLOBALS["year"];
global $db;
$query=$db->prepare("SELECT * FROM test WHERE `Billed Lot` = '".$station."' AND `Trip Billing End` LIKE '__/".$month."/".$year."%'");
$query->execute();
return $query->fetchAll();
}

function Car_data($station, $car)
{
$month=$_GLOBALS["month"];
$year=$_GLOBALS["year"];
global $db;
$query=$db->prepare("SELECT * FROM test WHERE `Billed Lot` = '".$station."' AND `Driven Vehicle Plate` = '".$car."' AND `Trip Billing End` LIKE '__/".$month."/".$year."%'");
$query->execute();
return $query->fetchAll();
}

function Tuser_data($station, $car)
{
$month=$_GLOBALS["month"];
$year=$_GLOBALS["year"];
global $db;
$query=$db->prepare("SELECT * FROM test WHERE `Billed Rate Plan` = '".$car."' AND `Trip Billing End` LIKE '__/".$month."/".$year."%'");
$query->execute();
return $query->fetchAll();
}

function Tcar_data($station, $car)
{
global $month, $year;
$month=$_GLOBALS["month"];
$year=$_GLOBALS["year"];
global $db;
if ($station)
{
$query=$db->prepare("SELECT * FROM test WHERE `Billed Lot` = '".$station."' AND `Driven Vehicle Type` = '".$car."' AND `Trip Billing End` LIKE '__/".$month."/".$year."%'");
}
else
{
$query=$db->prepare("SELECT * FROM test WHERE `Driven Vehicle Type` = '".$car."' AND `Trip Billing End` LIKE '__/".$month."/".$year."%'");
}
$query->execute();
return $query->fetchAll();
}


function prev_data($col, $type)
{
$month = $GLOBALS["month"];
$year = $GLOBALS["year"] - 1;

if ($type == "tcar")
{
$res = Tcar_data(null,$_GLOBALS["car"],$GLOBALS["year"],$GLOBALS["month"] );	
}
else if ($type == "car")
{
$res = Car_data($_GLOBALS["station"],$_GLOBALS["car"],$GLOBALS["year"],$GLOBALS["month"]);	
}
else if ($type == "station")
{
$res = Station_data($_GLOBALS["station"],$_GLOBALS["car"],$GLOBALS["year"],$GLOBALS["month"] );	
}
	$i = 0;
	$data = 0;
	while (isset($res[$i]))
	{
		$data += $res[$i++][$col];
	}
	return ($data);
}

function year_data($col, $type, $datas=null)
{
$nbyear=13;
$month = $GLOBALS["month"];
$year = $GLOBALS["year"] - 1;
while ($nbyear)
{
if ($month == 13)
{
$year++;
$month="01";
}
	$res = Get_data($type, $year, $month, $datas);	
	$i = 0;
	$data = 0;
	while (isset($res[$i]))
	{
		$data += $res[$i++][$col];
	}
	$ret[] = $data;
	$month++;
	if ($month < 10)
	{
		$month = "0".$month;
	}
	$nbyear--;
}
return ($ret);
}

function month_legend()
{
$month = $GLOBALS["month"];
$year = $GLOBALS["year"] - 1;
$c = 13;
while ($c)
{
if ($month == 13)
{
$year++;
$month=01;
}
	$ret[] = $month."/".$year;
	$month++;
	$c--;
}
return $ret;
}

function generate_graph($file="histogram.php", $data=array(), $title="Titre", $legend=array(), $unit)
{
	echo "<a href=".$file."?data=".serialize($data)."&title=".urlencode($title)."&legend=".urlencode(serialize($legend))."&unit=".$unit." class=\"bt_blue\"><span class=\"bt_blue_lft\"></span><strong>Voir le ".$title."</strong><span class=\"bt_blue_r\"></span></a>";	
}

function Disp($diagram, $data, $type, $title, $unit)
{
	if ($diagram == "histogram")
	{
	generate_graph("histogram.php", $data, $title, month_legend(),$unit);
	}
	else if ($diagram == "histogramd")
	{
	generate_graph("histogramd.php", $data, $title, month_legend(),$unit);
	}
	else
	{
	generate_graph("graphe.php", $data, $title, month_legend(),$unit);
	}
}

function Get_CaKm($data1, $data2)
{
$i = 0;
while (isset($data1[$i]))
{
if ($data2[$i] == 0)
{
$data1[$i] = 0;
}
else
{
$data1[$i] = bcdiv($data2[$i],$data1[$i],3);
}
$i++;
}
return $data1;	
}

function list_abon()
{
global $db;
	
$query=$db->prepare('SELECT `Driver Name`,DATE_FORMAT(DATE_SUB(DATE_FORMAT("'.date("d/m/y").'", "%d/%m/%y"), INTERVAL 6 MONTH), "%y/%m/%d")  FROM test WHERE (DATE_FORMAT(DATE_SUB(DATE_FORMAT("'.date("d/m/y").'", "%d/%m/%y"), INTERVAL 1 MONTH), "%y/%m/%d") is not null');
$query->execute();
$res = $query->fetchAll();
$i = 0;
var_dump($res);
exit;
$data = array();
	while (isset($res[$i]))
	{
		echo '<li><a href="station.php?station='.urlencode($res[$i]["Billed Lot"]).'&month='.urlencode($month).'&year='.urlencode($year).'">'.$res[$i++]["Billed Lot"].'</a></li>';
	}
	return $data;	
}

function list_Station($month, $year)
{
global $db;
$query=$db->prepare("SELECT DISTINCT `Billed Lot` FROM test WHERE `Trip Billing End` LIKE '__/".$month."/".$year."%'");
$query->execute();
$res = $query->fetchAll();
$i = 0;
$data = array();
	while (isset($res[$i]))
	{
		echo '<li><a href="station.php?station='.urlencode($res[$i]["Billed Lot"]).'&month='.urlencode($month).'&year='.urlencode($year).'">'.$res[$i++]["Billed Lot"].'</a></li>';
	}
	return $data;	
}

function list_Tuser($month, $year)
{
global $db;
$query=$db->prepare("SELECT DISTINCT `Billed Rate Plan` FROM test WHERE `Trip Billing End` LIKE '__/".$month."/".$year."%'");
$query->execute();
$res = $query->fetchAll();
$i = 0;
$data = array();
$tab = sort_typo2($res);
	while (isset($tab[$i]))
	{
		echo '<li><a href=tuser.php?tuser='.urlencode($tab[$i]).'&month='.urlencode($month).'&year='.urlencode($year).'>'.$tab[$i++].'</a></li>';
	}
	return $data;	
}

function list_Car($station, $month, $year)
{
global $db;
$query=$db->prepare("SELECT `Driven Vehicle Plate`, `Driven Vehicle Type` FROM test WHERE `Billed Lot` = '".$station."' AND `Trip Billing End` LIKE '__/".$month."/".$year."%' ORDER BY `Driven Vehicle Plate`");
$query->execute();
$res = $query->fetchAll();
$i = 0;
$nb = -1;
$data = $res[$i]["Driven Vehicle Plate"];
$tab = array();
$tab2 = array();
while (isset($res[$i]))
{
	$nb++;
	if ($data !== $res[$i]["Driven Vehicle Plate"])
	{
		$tab[($data)] = $nb;
		$tab2[($data)] = $res[$i-1]["Driven Vehicle Type"];
		$nb = 0;
	}
	$data = $res[$i++]["Driven Vehicle Plate"];
}
$tab[($data)] = ++$nb;
$tab2[($data)] = $res[$i-1]["Driven Vehicle Type"];
echo '
<table id="rounded-corner" summary="2007 Major IT Companies Profit">
    <thead>
    	<tr>
            <th scope="col" class="rounded">Voiture</th>
            <th scope="col" class="rounded">Typologie</th>
            <th scope="col" class="rounded">Réprésentation typologie</th>
        </tr>
    </thead>
    <tbody>
    ';
	while ($t = current($tab))
	{
	echo "<tr>";
	echo "<td><a href=car.php?car=".urlencode(key($tab))."&station=".urlencode($station)."&month=".urlencode($GLOBALS["month"])."&year=".urlencode($GLOBALS["year"]).">".key($tab)."</a></td>";
	echo "<td><a href=tcar.php?tcar=".urlencode($tab2[key($tab)])."&station=".urlencode($station)."&month=".urlencode($GLOBALS["month"])."&year=".urlencode($GLOBALS["year"]).">".$tab2[key($tab)]."</a></td>";
	echo "<td>".number_format(($t/sizeof($res) * 100), 2, '.', '')."% </td>";
	echo "</tr>";
	next($tab);
	}
	echo '</tbody></table>';
}


function list_Tcar($type)
{
$res = Get_data($type, $GLOBALS["year"], $GLOBALS["month"]);
$i = 0;
$nb = -1;
$data = $res[$i]["Driven Vehicle Type"];
$tab = array();
while (isset($res[$i]))
{
	$nb++;
	if ($data !== $res[$i]["Driven Vehicle Type"])
	{
		$tab[($data)] = $nb;
		$nb = 0;
	}
	$data = $res[$i++]["Driven Vehicle Type"];
}
$tab[($data)] = ++$nb;
	while ($t = current($tab))
	{
	echo "<a href=tcar.php?tcar=".urlencode(key($tab))."&station=".urlencode($station)."&month=".urlencode($GLOBALS["month"])."&year=".urlencode($GLOBALS["year"]).">".key($tab)."</a>";
	echo "<br>";
	next($tab);
	}
}

function isPrimary($keyz)
{
include "dictionnary.php";
foreach($typ as $key => $value)
{
	if (strtolower($keyz) == strtolower($key))
	{
		return true;
	}
}
return false;
}

function getPrimary($keyz)
{
include "dictionnary.php";
foreach($typ as $key => $value)
{
	foreach($typ[$key] as $key2 => $value)
	{
		if (strtolower($value) == strtolower($keyz))
		{
			return ($key);
		}
	}
}
return null;
}

function sort_typo($data)
{
include "dictionnary.php";
$ret = array();
foreach ($data as $key => $value)
{
	if (isset($key))
	{
		if (isPrimary($key) == true)
		{
			$ret[$key] = $data[$key];
		}
	}
}
foreach ($data as $key => $value)
{
	if (!isPrimary(strtolower($key)))
	{
		if (isset($value[$key]))
		{
		if ($keyz = getPrimary($value[$key]))
		{
			if (!isset($ret[$keyz]))
			{
				$ret[$keyz] = $data[$key];
			}
			else
			{
				$ret[$keyz] += $data[$key];
			}
		}
		}
	}
}
return $ret;
	#voir le parsing avec le dictionnaire
}

function isPrimary2($keyz)
{
include "dictionnary.php";
foreach($typ as $key => $value)
{
	if (strtolower($keyz) == strtolower($key))
	{
		return $keyz;
	}
}
return false;
}

function getPrimary2($keyz)
{
include "dictionnary.php";
foreach($typ as $key => $value)
{
	foreach($typ[$key] as $key2 => $value)
	{
		if (strtolower($value) == strtolower($keyz))
		{
			return ($key);
		}
	}
}
return null;
}

function typo_exist($tab, $typo)
{
  $i = 0;
  while (isset($tab[$i]))
  {
  	if ($tab[$i++] == $typo)
		return true;
  }
  return false;
}

function sort_typo2($data)
{
include "dictionnary.php";
$ret = array();
$val = 0;
foreach ($data as $key => $value)
{
		if (isPrimary($value[0]) == true)
		{
			$ret[$val++] = $value[0];
		}
}
foreach ($data as $key => $value)
{
	if (!isPrimary(strtolower($value[0])))
	{
		if (($keyz = getPrimary($value[0])) && !typo_exist($ret, $keyz))
		{
			if (!isset($ret[$val]))
			{
				$ret[$val++] = $keyz;
			}
			else
			{
				$ret[$val++] += $keyz;
			}
		}
	}
}
return $ret;
	#voir le parsing avec le dictionnaire
}
function Utilization($type, $datas=null)
{
$res = Get_data($type, $GLOBALS["year"], $GLOBALS["month"], $datas);
$i = 0;
$nb = -1;
$data = $res[$i]["Billed Rate Plan"];
$tab = array();
while (isset($res[$i]))
{
	$nb++;
	if ($data !== $res[$i]["Billed Rate Plan"])
	{
		$tab[($data)] = $nb;
		$nb = 0;
	}
	$data = $res[$i++]["Billed Rate Plan"];
}
$tab[$data] = ++$nb;
	$data = array();
	$legend = array();
	$tab = sort_typo($tab);
	while ($t = current($tab))
	{
	$data[] = $t;
	$legend[] = key($tab);
	next($tab);
	}
	$title="Répartition de l'utilisation par typologie de client";
	generate_graph("graphe.php", $data, $title, $legend, "test");
}

function Car_utilization($station, $car)
{
global $db;
$query=$db->prepare("SELECT `Billed Rate Plan` FROM test WHERE `Billed Lot` = '".$station."' AND `Driven Vehicle Plate` = '".$car."' ORDER BY `Billed Rate Plan`");
$query->execute();
$res = $query->fetchAll();
$i = 0;
$nb = -1;
$data = $res[$i]["Billed Rate Plan"];
$tab = array();
while (isset($res[$i]))
{
	$nb++;
	if ($data !== $res[$i]["Billed Rate Plan"])
	{
		$tab[($data)] = $nb;
		$nb = 0;
	}
	$data = $res[$i++]["Billed Rate Plan"];
}
$tab[($data)] = ++$nb;
	$data = array();
	$legend = array();

	while ($t = current($tab))
	{
	$data[] = $t;
	$legend[] = key($tab);
	next($tab);
	}
	$title="Taux d'utilisation de la voiture par typologie de client";
	generate_graph("graphe.php", $data, $title, $legend, "test");
}

function Tcar_utilization($station, $car)
{
global $db;
$query=$db->prepare("SELECT `Billed Rate Plan` FROM test WHERE `Billed Lot` = '".$station."' AND `Driven Vehicle Type` = '".$car."' ORDER BY `Billed Rate Plan`");
$query->execute();
$res = $query->fetchAll();
$i = 0;
$nb = -1;
$data = $res[$i]["Billed Rate Plan"];
$tab = array();
while (isset($res[$i]))
{
	$nb++;
	if ($data !== $res[$i]["Billed Rate Plan"])
	{
		$tab[($data)] = $nb;
		$nb = 0;
	}
	$data = $res[$i++]["Billed Rate Plan"];
}
$tab[($data)] = ++$nb;
	$data = array();
	$legend = array();
	while ($t = current($tab))
	{
	$data[] = $t;
	$legend[] = key($tab);
	next($tab);
	}
	$title="Taux d'utilisation de la typologie de la voiture par typologie de client";
	generate_graph("graphe.php", $data, $title, $legend, "test");

}

function carExist($tab, $str)
{
$i = 0;
if (!$tab)	return true;
while (isset($tab[$i]))
{
if ($tab[$i] == $str)
{
return true;
}
$i++;
}
return false;
}

function createRet($tab, $cars)
{
	$i = 0;
	$ret = 0;
	while (isset($tab[$i]))
	{
		$val = count($cars);
		echo $val;
		if ($val == 0)
		{
			$val=1;
		}
		$ret += ($tab[$i++] * 100)/(24 * $val);
	}
	return $ret;
}

function Stat_hebdo($year, $month, $day, $decr, $nbd)
{
while ($nbd >= 0)
{
	$i = 0;
	$data = Get_data("hebdo", $year, $month, array("day" => $day, "station" => $GLOBALS["station"]));
	echo "Il te manque une info -> voir classeur";
	while (isset($data[$i]))
	{
		var_dump($data[$i++]["Trip Billing End"]);
	}
	$nbd -= $decr;

}
}
function test($year, $month, $day, $decr, $nbd)
{
$r = 0;
$cars = array();
	
while ($nbd >=  0)
{
$test = new DateTime(date("Y-m-d", strtotime(date("d/m/y", strtotime((string)($month)."/".$day."/".$year)))));
$i = 0;
$re = array();
	$data = Get_data("hebdo", $year, $month, array("day" => $day, "station" => $GLOBALS["station"], "nbd" => $nbd));
	echo "<br>";
	var_dump($data[$i]["Trip Billing End"]);
	echo "<br><br>";
	if ($nbd < 21)
	{
	echo"<br>";
	$cur_date = (string)($test->modify("-".$nbd." day")->format('d/m/y'));
	$year = (string)$test->format('y');
	$month = (string)$test->format('m');
	$day = (string)$test->format('d');
	}
	else
	{
	$cur_date = (string)$test->format('d/m/y');
	}
	echo $day;
	echo "<br>";
	echo $month;
	echo "<br>";
	echo $year;
	echo "<br>";
	echo $cur_date;
	echo "<br>";
	var_dump($test);
	if ($nbd == 0) exit;
	while (isset($data[$i]))
	{
		$begin = $data[$i]["Trip Billing Start"];
		$end = $data[$i]["Trip Billing End"];
		$endtime = new DateTime(date("H:i", strtotime($end)));
		$begtime = new DateTime(date("H:i", strtotime($begin)));
		if (carExist($cars, $data[$i]["Driven Vehicle Plate"]))
		{
			$cars[] = $data[$i]["Driven Vehicle Plate"];
		}
		if (date("m/d/y", strtotime($begin)) == $cur_date)
		{
			if (date("m/d/y", strtotime($end)) == $cur_date)
			{
				$r = $begtime->diff($endtime)->format("%h.%i");	
			}
			else
			{
				$sub =new DateTime(date("H.i", strtotime("24:00")));
				$r = $begtime->diff($sub)->format("%h.%i");
			}
		}
		else
		{
			if ($end == "0".($day - $nbd)."/".$month."/".$year)
			{
				$r = $endtime->format("%h.%i");
			}
			else
			{
				$r = 24.00;
			}
		}
		$test = preg_split("`\.`", $r);
		$re[] = (float)($r);
		$i++;
		unset($test);
	}
	$legend[] = $cur_date;
	$ret[] = createRet($re, $cars);
	$nbd -= $decr;
}
exit;
	header('Location: histogram.php?data='.serialize($ret).'&title='.urlencode("Taux d'utilisation par stations").'&legend='.urlencode(serialize($legend)).'&unit=pourcent');	
}
function Stat_hebdo_car($year, $month, $day, $decr, $nbd)
{
$i = 0;
$r = 0;
while ($nbd >  0)
{
	$i = 0;
	$re = array();
	$data = Get_data("hebdo_car", $year, $month, array("day" => $day, "station" => $GLOBALS["station"], "nbd" => $nbd, "car" => $GLOBALS["car"]));
	$cur_date = date("m/d/y", strtotime((string)($day - $nbd)."/".$month."/".$year));
	while (isset($data[$i]))
	{
		$begin = $data[$i]["Trip Billing Start"];
		$end = $data[$i]["Trip Billing End"];
		$endtime = new DateTime(date("H:i", strtotime($end)));
		$begtime = new DateTime(date("H:i", strtotime($begin)));
		if (date("m/d/y", strtotime($begin)) == $cur_date)
		{
			if (date("m/d/y", strtotime($end)) == $cur_date)
			{
				$r = $begtime->diff($endtime)->format("%h.%i");	
			}
			else
			{
				$sub =new DateTime(date("H.i", strtotime("24:00")));
				$r = $begtime->diff($sub)->format("%h.%i");
			}
		}
		else
		{
			if ($end == "0".($day - $nbd)."/".$month."/".$year)
			{
				$r = $endtime->format("%h.%i");
			}
			else
			{
				$r = 24.00;
			}
		}
		$test = preg_split("`\.`", $r);
		$re[] = (float)($r);
		$i++;
	}
	$legend[] = $cur_date;
	$ret[] = createRet($re, 1);
	$nbd -= $decr;
}
	echo "<br><a href=histogram.php?data=".serialize($ret)."&title=".urlencode("Taux d'utilisation par stations")."&legend=".urlencode(serialize($legend))."&unit=pourcent><button>Voir la répartition d'utilisations par voitures</button></a><br>";	
}

function Station_utilization($station)
{
global $db;
$query=$db->prepare("SELECT `Billed Rate Plan` FROM test WHERE `Billed Lot` = '".$station."' ORDER BY `Billed Rate Plan`");
$query->execute();
$res = $query->fetchAll();
$i = 0;
$nb = -1;
$data = $res[$i]["Billed Rate Plan"];
$tab = array();
while (isset($res[$i]))
{
	$nb++;
	if ($data !== $res[$i]["Billed Rate Plan"])
	{
		$tab[($data)] = $nb;
		$nb = 0;
	}
	$data = $res[$i++]["Billed Rate Plan"];
}
$tab[($data)] = ++$nb;
	$data = array();
	$legend = array();
	while ($t = current($tab))
	{
	$data[] = $t;
	$legend[] = key($tab);
	next($tab);
	}
	$title="Taux d'utilisation de la station par typologie de client";
	generate_graph("graphe.php", $data, $title, $legend, "test");
}

function memberExist($member, $list)
{
	$i = 0;
	while (isset($list[$i]))
	{
		if ($list[$i]["Member Name"] == $member)
		{
			return $i;	
		}
		$i++;
	}
	return false;
}

function sort_tab($tab)
{
	$i = 0;
	$csv = array();
	$nb = 0;
	while (isset($tab[$i]))
	{
		if ((isPrimary2($tab[$i]["Account Rate Plan"]) == "Liberté" || getPrimary2($tab[$i]["Account Rate Plan"]) == "Liberté") && $tab[$i]["Total Amount"] >= 100)	
			$csv[$nb++] = $tab[$i]["Member Name"].";".$tab[$i]["Account Rate Plan"].";".$tab[$i]["Total Amount"];
		else if (((isPrimary2($tab[$i]["Account Rate Plan"]) == "PRO" || getPrimary2($tab[$i]["Account Rate Plan"]) == "PRO")&& $tab[$i]["Total Amount"] >= 300)	
			$csv[$nb++] = $tab[$i]["Member Name"].";".$tab[$i]["Account Rate Plan"].";".$tab[$i]["Total Amount"];
		else if ($tab[$i]["Total Amount"] >= 150)
			$csv[$nb++] = $tab[$i]["Member Name"].";".$tab[$i]["Account Rate Plan"].";".$tab[$i]["Total Amount"];
	$i++;
	}
	return $csv;
}

function alert()
{
$date = getdate();
if ($date["mon"] <= 9)
{
	$date["mon"] = "0".$date["mon"];
}
global $db;
$tab = array();
$i = 0;
$nb = 0;
$val = 0;
echo $date["mon"];
$query=$db->prepare("SELECT * FROM test WHERE `Trip Billing Start` LIKE '__/"."01"."/".substr($date["year"], 2)."%'");
$query->execute();
$res = $query->fetchAll();
while (isset($res[$i]))
	{
		if (isPrimary2($res[$i]["Account Rate Plan"]) == "Liberté" || getPrimary2($res[$i]["Account Rate Plan"]) == "Liberté")
		{
			if ( ($val = memberExist($res[$i]["Member Name"], $tab)) !== false )
			{
				$tab[$val]["Total Amount"] += $res[$i]["Total Amount"];
				
			}
			else
			{
			$tab[$nb]["Member Name"] = $res[$i]["Member Name"];
			$tab[$nb]["Account Rate Plan"] = $res[$i]["Account Rate Plan"];
			$tab[$nb++]["Total Amount"] = $res[$i]["Total Amount"];
			}
		}
		else if (isPrimary2($res[$i]["Account Rate Plan"]) == "PRO" || getPrimary2($res[$i]["Account Rate Plan"]) == "PRO" || isPrimary2($res[$i]["Account Rate Plan"]) == "Rectorat" || getPrimary2($res[$i]["Account Rate Plan"]) == "Rectorat" || isPrimary2($res[$i]["Account Rate Plan"]) == "Groupement" || getPrimary2($res[$i]["Account Rate Plan"]) == "Groupement")
		{
			if (($val = memberExist($res[$i]["Member Name"], $tab)) !== false)
			{
				$tab[$val]["Total Amount"] += $res[$i]["Total Amount"];
			}
			else
			{
			$tab[$nb]["Member Name"] = $res[$i]["Member Name"];
			$tab[$nb]["Account Rate Plan"] = $res[$i]["Account Rate Plan"];
			$tab[$nb++]["Total Amount"] = $res[$i]["Total Amount"];
			}
		}
		else
		{
			if (($val = memberExist($res[$i]["Member Name"], $tab)) !== false)
			{
				$tab[$val]["Total Amount"] += $res[$i]["Total Amount"];
			}
			else
			{
			$tab[$nb]["Member Name"] = $res[$i]["Member Name"];
			$tab[$nb]["Account Rate Plan"] = $res[$i]["Account Rate Plan"];
			$tab[$nb++]["Total Amount"] = $res[$i]["Total Amount"];
			}
		}
		$i++;
	}
	$i = 0;	
	$tab = sort_tab($tab);
	$fp = fopen('alert.csv', 'w');
	while (isset($tab[$i]))
	{
		echo $tab[$i];
		fwrite($fp, $tab[$i]."\n");
		$i++;
	}
	fclose($fp);
	echo system('/usr/local/bin/python3.4 send_email.py');
	echo "<br><br>Envois REUSSI";
}
?>
