import smtplib, os
from email.mime.multipart import MIMEMultipart
from email.mime.base import MIMEBase
from email.mime.text import MIMEText
from email.utils import COMMASPACE, formatdate
from email import encoders
import datetime, re

def send_mail( send_from, send_to, subject, text, files=[], server="localhost", port=587, username='', password='', isTls=True):
    msg = MIMEMultipart()
    msg['From'] = send_from
    msg['To'] = COMMASPACE.join(send_to)
    msg['Date'] = formatdate(localtime = True)
    msg['Subject'] = subject
    msg.attach(MIMEText(text))
    for f in files:
        part = MIMEBase('application', "octet-stream")
        part.set_payload( open(f,"rb").read() )
        encoders.encode_base64(part)
        part.add_header('Content-Disposition', 'attachment; filename="{0}"'.format(os.path.basename(f)))
        msg.attach(part)
    smtp = smtplib.SMTP(server, port)
    if isTls:
        smtp.starttls()
        #smtp.login(username,password)
        smtp.sendmail(send_from, send_to, msg.as_string())
        smtp.quit()
date = re.sub(r' .*',r'',str(datetime.datetime.now())).split("-")
date=date[1] + "_" + date[2] + "_" + date[0]
send_mail("postmaster@modulauto.net", "compta@modulauto.net", "Alerte email automatique(ne pas repondre)", "Alerte Mensuelle pour tout les abonnÃ©s", ["/home/kidoysde/www/modulauto/design/alert.csv"], "smp.orange.fr", 25)
